@include('admin/header')
<div class="wrapper">
    <!-- Sidebar  -->
    @include('admin/sidebar')
    <!-- Page Content  -->
    <div id="content">
        @include('admin/nav')
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mb-5">
                    <h2>CREACIÓN DE CERTIFICADOS</h2>
                </div>
                <div class="col-md-12">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                    @endif
                    <form method="POST" action="{{ route('generar-certificado-pdf') }}" id="enviarPDFForm">
                        @csrf
                        <div class="row">
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label for="nombre_graduado">Nombre del graduado</label>
                                    <input type="text" class="form-control" id="nombre_graduado" name="nombre_graduado"
                                        value="{{ old('nombre_graduado') }}">
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label for="correo_graduado">Correo del graduado</label>
                                    <input type="email" class="form-control" id="email_graduado" name="email_graduado"
                                        value="{{ old('email_graduado') }}">
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label for="fecha_certificacion">Fecha de certificación</label>
                                    <input type="text" name="fecha_certificacion" id="fecha_certificacion"
                                        class="form-control" />
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label for="id_curso_graduacion">Curso de graduación</label>
                                    <select class="form-control" id="id_curso_graduacion" name="id_curso_graduacion">
                                        <option value="">Seleccione un curso</option>
                                        @foreach ($cursos as $curso)
                                        <option value="{{ $curso->id }}">{{ $curso->nombre }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <button type="submit" class="btn-enviar">Generar PDF</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('input[name="fecha_certificacion"]').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            minYear: 1901,
            // maxYear: parseInt(moment().format('YYYY'),10),
            locale: {
                "format": "DD/MM/YYYY",
                "separator": " - ",
                "applyLabel": "Aplicar",
                "cancelLabel": "Cancelar",
                "fromLabel": "DE",
                "toLabel": "HASTA",
                "customRangeLabel": "Custom",
                "daysOfWeek": [
                    "Dom",
                    "Lun",
                    "Mar",
                    "Mie",
                    "Jue",
                    "Vie",
                    "Sáb"
                ],
                "monthNames": [
                    "Enero",
                    "Febrero",
                    "Marzo",
                    "Abril",
                    "Mayo",
                    "Junio",
                    "Julio",
                    "Agosto",
                    "Septiembre",
                    "Octubre",
                    "Noviembre",
                    "Diciembre"
                ],
                "firstDay": 1
            }
        });
    });
    
    $('#enviarPDFForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });
</script>
@include('admin/footer')