@include('admin/header')
<div class="wrapper">
    <!-- Sidebar  -->
    @include('admin/sidebar')
    <!-- Page Content  -->
    <div id="content">
        @include('admin/nav')
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 mb-5">
                    <h2>CREACIÓN DE CURSOS</h2>
                </div>
                <div class="col-md-12">
                    <div class="signup-step-container mt-5">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="wizard">
                                    <div class="wizard-inner">
                                        <div class="connecting-line"></div>
                                        <ul class="nav nav-tabs align-items-center justify-content-center"
                                            role="tablist">
                                            <li role="presentation"
                                                class="disabled {{ session('tab') == 'step1' ? 'active' : '' }}">
                                                <a href="#" aria-controls="step1" role="tab" aria-expanded="true"><span
                                                        class="round-tab">1 </span></a>
                                            </li>
                                            <li role="presentation"
                                                class="disabled {{ session('tab') == 'step2' ? 'active' : '' }}">
                                                <a href="#" aria-controls="step2" role="tab" aria-expanded="false"><span
                                                        class="round-tab">2</span></a>
                                            </li>
                                            <li role="presentation"
                                                class="disabled {{ session('tab') == 'step3' ? 'active' : '' }}">
                                                <a href="#" aria-controls="step3" role="tab"><span
                                                        class="round-tab">3</span></a>
                                            </li>
                                        </ul>
                                    </div>

                                    <div class="tab-content" id="main_form">
                                        <div class="tab-pane {{ session('tab') == 'step1' ? 'active' : '' }} pb-5"
                                            role="tabpanel" id="step1">
                                            @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                            @endif
                                            <form action="/registrar-curso" method="POST" enctype="multipart/form-data"
                                                id="registrarCursoForm">
                                                @csrf
                                                <h4 class="mb-4 mt-4">Información del curso</h4>
                                                <div class="row">
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label for="curso">Nombre de curso</label>
                                                            <input class="form-control" type="text" name="nombre_curso"
                                                                id="nombre_curso" value="{{ old('nombre_curso') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label for="precio_actual">Precio actual</label>
                                                            <input class="form-control" type="text" name="precio_actual"
                                                                id="precio_actual" value="{{ old('precio_actual') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label for="precio_original">Precio original
                                                                (opcional)</label>
                                                            <input class="form-control" type="text"
                                                                name="precio_original" id="precio_original"
                                                                value="{{ old('precio_original') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Subir la portada</label>
                                                            <div class="custom-file">
                                                                <input type="file" class="custom-file-input"
                                                                    id="imagen_curso" name="imagen_curso">
                                                                <label class="custom-file-label" for="imagen_curso">
                                                                    <i class="fas fa-upload"></i> Upload
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label for="cantidad_cursos">Cantidad de cursos</label>
                                                            <input class="form-control" type="text"
                                                                name="cantidad_cursos" id="cantidad_cursos"
                                                                value="{{ old('cantidad_cursos') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label for="cantidad_paquetes">Cantidad de paquetes</label>
                                                            <input class="form-control" type="text"
                                                                name="cantidad_paquetes" id="cantidad_paquetes"
                                                                value="{{ old('cantidad_paquetes') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label for="descripcion">Descripción</label>
                                                            <input class="form-control" type="text" name="descripcion"
                                                                id="descripcion" value="{{ old('descripcion') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label class="pt-xl-4 pt-lg-4 pt-md-4 pt-sm-4 pt-0"></label>
                                                            <div class="custom-control custom-switch">
                                                                {{-- <input type="checkbox" class="custom-control-input"
                                                                    id="corona" name="corona"> --}}
                                                                <input type="checkbox" id="corona" name="corona"
                                                                    class="custom-control-input">

                                                                <label class="custom-control-label" for="corona">Asignar
                                                                    corona</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="contenido">Contenido del Curso</label>
                                                            <textarea rows="10" id="contenido"
                                                                name="contenido">{{ old('contenido') }}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <button type="submit" class="default-btn next-step">
                                                            Siguiente
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="tab-pane {{ session('tab') == 'step2' ? 'active' : '' }} pb-5 mb-5"
                                            role="tabpanel" id="step2">
                                            @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                            @endif
                                            @if (session('success'))
                                            <div class="alert alert-success">
                                                {{ session('success') }}
                                            </div>
                                            @endif
                                            <form action="/registrar-seccion" method="POST"
                                                enctype="multipart/form-data" id="registrarSeccionForm">
                                                @csrf
                                                <h4 class="mt-4 mb-4">Creación de Sección</h4>
                                                <div class="row">
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Nombre de la sección</label>
                                                            <input class="form-control" type="text"
                                                                name="nombre_seccion" id="nombre_seccion"
                                                                value="{{ old('nombre_seccion') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Título de la sección</label>
                                                            <input class="form-control" type="text"
                                                                name="titulo_seccion" id="titulo_seccion"
                                                                value="{{ old('titulo_seccion') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Foto/Video de la sección</label>
                                                            <div class="custom-file">
                                                                <input type="file" class="custom-file-input"
                                                                    id="archivo_seccion" name="archivo_seccion">
                                                                <label class="custom-file-label" for="archivo_seccion">
                                                                    <i class="fas fa-upload"></i> Upload
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Subtítulo de la sección</label>
                                                            <input class="form-control" type="password"
                                                                name="subtitulo_seccion" id="subtitulo_seccion"
                                                                value="{{ old('subtitulo_seccion') }}">
                                                        </div>
                                                    </div>
                                                    <input type="hidden" name="id_curso"
                                                        value="{{ session('id_curso') }}">
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <button type="submit" class="btn-enviar">Registrar
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 mt-5">
                                                        <table id="datos"
                                                            class="table table-striped table-bordered nowrap"
                                                            style="width:100%" aria-describedby="mydesc">
                                                            <thead>
                                                                <tr>
                                                                    {{-- <th>Nº Orden</th> --}}
                                                                    <th>Nombre</th>
                                                                    <th>Título</th>
                                                                    <th>Subtitulo</th>
                                                                    <th>Acción</th>
                                                                </tr>
                                                            </thead>
                                                            @if (isset($secciones))
                                                            <tbody>
                                                                @foreach ($secciones as $seccion)
                                                                <tr>
                                                                    {{-- <td>1</td> --}}
                                                                    <td>{{ $seccion->nombre }}</td>
                                                                    <td>{{ $seccion->titulo }}</td>
                                                                    <td>{{ $seccion->subtitulo }}</td>
                                                                    <td class="accion">
                                                                        <a href="
                                                                        {{ route('paso-crear-clase',
                                                                            ['id_seccion' => $seccion->id,
                                                                            'id_curso' => session('id_curso') ]) }}">
                                                                            <i class="fas fa-pencil-alt"></i></a>
                                                                        <a href="javascript:void(0)" class="borrar"
                                                                            data-id="{{ $seccion->id }}"
                                                                            data-toggle="modal"
                                                                            data-target="#eliminarSeccionModal">
                                                                            <i class="fas fa-trash-alt"></i></a>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                            @endif
                                                        </table>
                                                        @if (isset($secciones) && method_exists($secciones, 'links'))
                                                        {{ $secciones->links() }}
                                                        @endif

                                                    </div>
                                                </div>
                                            </form>


                                            {{-- <ul class="list-inline pull-right">
                                                <li>
                                                    <button type="button" class="default-btn prev-step">
                                                        Anterior
                                                    </button>
                                                </li>
                                                <li>
                                                    <button type="button" class="default-btn next-step">
                                                        Siguiente
                                                    </button>
                                                </li>
                                            </ul> --}}
                                        </div>
                                        <div class="tab-pane {{ session('tab') == 'step3' ? 'active' : '' }} mb-5 pb-5"
                                            role="tabpanel" id="step3">
                                            @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                            @endif
                                            @if (session('success'))
                                            <div class="alert alert-success">
                                                {{ session('success') }}
                                            </div>
                                            @endif
                                            <form action="/registrar-clase" method="POST" enctype="multipart/form-data"
                                                id="registrarClaseForm">
                                                @csrf
                                                <h4 class="mt-4 mb-4">Creación de Clase</h4>
                                                <div class="row">
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Nombre de la clase</label>
                                                            <input class="form-control" type="text" name="nombre_clase"
                                                                value="{{ old('nombre_clase') }}" id="nombre_clase">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Detalle de la clase</label>
                                                            <input class="form-control" type="text" name="detalle_clase"
                                                                value="{{ old('detalle_clase') }}" id="detalle_clase">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Url de la clase</label>
                                                            <input class="form-control" type="text" name="url_clase"
                                                                value="{{ old('url_clase') }}" id="url_clase">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label>Url de material de descarga</label>
                                                            <input class="form-control" type="text" name="url_material"
                                                                value="{{ old('url_material') }}" id="url_material">
                                                        </div>
                                                    </div>
                                                    <input type="hidden" name="id_seccion"
                                                        value="{{ session('id_seccion') }}">
                                                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <button type="submit" class="btn-enviar">
                                                                Registrar
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 mt-5">
                                                        <table id="clases1"
                                                            class="table table-striped table-bordered nowrap"
                                                            style="width:100%" aria-describedby="mydesc">
                                                            <thead>
                                                                <tr>
                                                                    {{-- <th>Nº Orden</th> --}}
                                                                    <th>Nombre</th>
                                                                    <th>Detalle</th>
                                                                    <th>Url de la clase</th>
                                                                    <th>Url de material de descarga</th>
                                                                    <th>Acción</th>
                                                                </tr>
                                                            </thead>
                                                            @if (isset($clases))
                                                            <tbody>
                                                                @foreach ($clases as $clase)
                                                                <tr>
                                                                    {{-- <td>1</td> --}}
                                                                    <td>{{ $clase->nombre }}</td>
                                                                    <td>{{ $clase->detalle }}</td>
                                                                    <td>{{ $clase->url_clase }}</td>
                                                                    <td>{{ $clase->url_material }}</td>
                                                                    <td class="accion">
                                                                        <a href="javascript:void(0)" class="borrar"
                                                                            data-id="{{ $clase->id }}"
                                                                            data-toggle="modal"
                                                                            data-target="#eliminarClaseModal">
                                                                            <i class="fas fa-trash-alt"></i></a>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                            @endif

                                                            </tbody>
                                                        </table>
                                                        @if (isset($clases) && method_exists($clases, 'links'))
                                                        {{ $clases->links() }}
                                                        @endif
                                                    </div>
                                                </div>
                                            </form>
                                            <ul class="list-inline pull-right">
                                                <li>
                                                    <button type="button" class="default-btn prev-step">
                                                        <a href="{{ route('paso-crear-seccion',
                                                            ['id_curso' => session('id_curso')]) }}">
                                                            Anterior</a>
                                                    </button>
                                                </li>
                                                {{-- <li>
                                                    <button type="button" class="default-btn next-step">
                                                        Registrar
                                                    </button>
                                                </li> --}}
                                            </ul>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="eliminarSeccionModal" tabindex="-1" role="dialog" aria-labelledby="eliminarCursoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eliminarCursoModalLabel">Eliminar sección</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                ¿Estás seguro de que quieres eliminar la sección?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <form id="eliminarSeccionForm" action="/eliminar-seccion" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Confirmar</button>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="eliminarClaseModal" tabindex="-1" role="dialog" aria-labelledby="eliminarCursoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eliminarCursoModalLabel">Eliminar clase</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                ¿Estás seguro de que quieres eliminar la clase?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <form id="eliminarClaseForm" action="/eliminar-clase" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Confirmar</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // new DataTable('#datos', {
    //     responsive: true,
    //     language: {
    //         url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json',
    //     },
    // });
    // new DataTable('#clases1', {
    //     responsive: true,
    //     language: {
    //         url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json',
    //     },
    // });

    RedactorX('#contenido');

    // Bloquear el botón de submit al enviar el formulario para evitar doble envío
    $('#registrarCursoForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });
    $('#registrarSeccionForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });
    $('#registrarClaseForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });

    $('#eliminarSeccionModal').on('show.bs.modal', function(e) {
        var borrarLink = $(e.relatedTarget);
        var id = borrarLink.data('id');
        var eliminarSeccionForm = $('#eliminarSeccionForm');

        eliminarSeccionForm.attr('action', '/eliminar-seccion/' + id);
    });

    $('#eliminarSeccionForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });

    $('#eliminarClaseModal').on('show.bs.modal', function(e) {
        var borrarLink = $(e.relatedTarget);
        var id = borrarLink.data('id');
        var eliminarClaseForm = $('#eliminarClaseForm');

        eliminarClaseForm.attr('action', '/eliminar-clase/' + id);
    });

    $('#eliminarClaseForm').on('submit', function() {
        $(this).find('input[type=submit], button').prop('disabled', true);
    });

    



    /*$('#summernote').summernote({
        placeholder: 'Hello stand alone ui',
        tabsize: 2,
        height: 100,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'clear']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'video']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });*/
</script>
@include('admin/footer')